#ifndef TOOLCONFIG_H
#define TOOLCONFIG_H

#include <QDialog>
#include <ui_ToolConfig.h>

class ModelData;
class ToolSpecificConfig;

class QrfeReaderInterface;

class ToolConfig : public QDialog
{
    Q_OBJECT

public:
    typedef enum {
    	SINGLE_READER,
    	MULTIPLE_READER,
    	SINGLE_READER_WITH_SINGLE_TAG,
    	SINGLE_READER_WITH_MULTIPLE_TAGS,
    } ConfigType;


    ToolConfig(QPixmap icon, QString name, QString description, ConfigType type, ModelData* modelData, QWidget *parent = 0);
    ToolConfig(QPixmap icon, QString name, QString description, ConfigType type, ModelData* modelData, ToolSpecificConfig* specificConfig, QWidget *parent = 0);
    ~ToolConfig();

    QList<QrfeReaderInterface*>  	readerList();
    QList<QString> 					tagList();

private:
    void buildUpUi();

    void buildUpUi_SINGLE_READER();
    void buildUpUi_MULTIPLE_READER();
    void buildUpUi_SINGLE_READER_WITH_TAG();

    void removeReaderEntries();
    void removeTagEntries();

private slots:
	void tryAccept();
    void shrink();
    void singleReaderSelected(bool selected);

private:
    Ui::ToolConfigClass ui;

    QPixmap					m_icon;
    QString 				m_name;
    QString 				m_description;
    ConfigType 				m_type;
    ModelData* 				m_modelData;
    ToolSpecificConfig* 	m_specificConfig;

    QList<QAbstractButton*> 	m_readerEntries;
    QList<QAbstractButton*> 	m_tagEntries;

    QList<QrfeReaderInterface*>  	m_readerList;
    QList<QString> 					m_tagList;

};

#endif // TOOLCONFIG_H
